/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker;

import LegendaryCardMaker.CardMakerToolbar;
import LegendaryCardMaker.CustomCardMaker.gui.CustomTemplateList;
import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.CustomCardMaker.structure.CustomTemplate;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCardSelector;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCard;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCardType;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeMakerFrame;
import LegendaryCardMaker.LegendaryVillainMaker.Villain;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCard;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCardSelector;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCardType;
import LegendaryCardMaker.LegendaryVillainMaker.VillainMakerFrame;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LegendaryCardMakerFrame
extends JFrame {
    public static final String FRAME_NAME = "Legendedit";
    public LegendaryCardMaker lcm;
    public JTabbedPane tabs;
    public JList heroList;
    public DefaultListModel heroListModel;
    JScrollPane heroScroll = new JScrollPane();
    public JList villainList;
    public DefaultListModel villainListModel;
    JScrollPane villainScroll = new JScrollPane();
    public JList bystanderList;
    public DefaultListModel bystanderListModel;
    JScrollPane bystanderScroll = new JScrollPane();
    public JList woundList;
    public DefaultListModel woundListModel;
    JScrollPane woundScroll = new JScrollPane();
    public JList bindingsList;
    public DefaultListModel bindingsListModel;
    JScrollPane bindingsScroll = new JScrollPane();
    public JList schemeList;
    public DefaultListModel schemeListModel;
    JScrollPane schemeScroll = new JScrollPane();
    public JList schemeTypeList;
    public DefaultListModel schemeTypeListModel;
    JScrollPane schemeTypeScroll = new JScrollPane();
    public JList teamList;
    public DefaultListModel teamListModel;
    JScrollPane teamScroll = new JScrollPane();
    public HashMap<String, CustomTemplateList> customTemplateListSet = new HashMap();
    public Properties applicationProps = new Properties();
    CardMakerToolbar toolbar;
    public static LegendaryCardMakerFrame lcmf;
    private Locale currentLocale = Locale.getDefault();
    private ResourceBundle labels = ResourceBundle.getBundle("LegendaryCardMaker.tools.language.LegendaryCardMakerMenu", this.currentLocale);

    public LegendaryCardMakerFrame(LegendaryCardMaker lcm) {
        File file;
        File file2;
        File file3;
        this.setTitle("Legendedit - [Untitled]");
        lcmf = this;
        this.loadProperties();
        if (this.applicationProps.get("lastExpansion") != null) {
            lcm.ignoreGenerate = true;
            File file4 = new File((String)this.applicationProps.get("lastExpansion"));
            if (file4.exists()) {
                lcm.processInput((String)this.applicationProps.get("lastExpansion"));
                lcmf.setTitle("Legendedit - " + new File((String)this.applicationProps.get("lastExpansion")).getName());
            }
        }
        if (this.applicationProps.get("lastExportDirectory") != null && (file3 = new File((String)this.applicationProps.get("lastExportDirectory"))).exists()) {
            lcm.exportFolder = (String)this.applicationProps.get("lastExportDirectory");
        }
        if (this.applicationProps.get("lastOpenDirectory") != null && (file2 = new File((String)this.applicationProps.get("lastOpenDirectory"))).exists()) {
            lcm.lastOpened = (String)this.applicationProps.get("lastOpenDirectory");
        }
        if (this.applicationProps.get("lastSaveDirectory") != null && (file = new File((String)this.applicationProps.get("lastSaveDirectory"))).exists()) {
            lcm.lastSaved = (String)this.applicationProps.get("lastSaveDirectory");
        }
        this.setDefaultCloseOperation(3);
        this.lcm = lcm;
        this.tabs = new JTabbedPane();
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    JTabbedPane pane = (JTabbedPane)e.getSource();
                    if (LegendaryCardMakerFrame.this.toolbar != null) {
                        LegendaryCardMakerFrame.lcmf.applicationProps.put("lastTab", pane.getTitleAt(pane.getSelectedIndex()));
                        lcmf.saveProperties();
                        LegendaryCardMakerFrame.this.toolbar.setEditMenu();
                    }
                }
            }
        });
        this.heroListModel = new DefaultListModel();
        Collections.sort(lcm.heroes, new Hero());
        for (Hero hero : lcm.heroes) {
            this.heroListModel.addElement(hero);
        }
        this.heroList = new JList(this.heroListModel);
        this.heroList.setCellRenderer(new HeroListRenderer());
        this.heroList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    new HeroCardSelector((Hero)list.getSelectedValue(), lcmf);
                }
            }
        });
        this.heroScroll.setViewportView(this.heroList);
        this.add(this.heroScroll);
        this.tabs.add("Heroes", this.heroScroll);
        this.villainListModel = new DefaultListModel();
        Collections.sort(lcm.villains, new Villain());
        for (Villain villain : lcm.villains) {
            if (villain.name.equals("system_bystander_villain") || villain.name.equals("system_wound_villain") || villain.name.equals("system_bindings_villain")) continue;
            this.villainListModel.addElement(villain);
        }
        this.villainList = new JList(this.villainListModel);
        this.villainList.setCellRenderer(new VillainListRenderer());
        this.villainList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    new VillainCardSelector((Villain)list.getSelectedValue(), lcmf);
                }
            }
        });
        this.villainScroll.setViewportView(this.villainList);
        this.add(this.villainScroll);
        this.tabs.add("Villains", this.villainScroll);
        this.bystanderListModel = new DefaultListModel();
        Collections.sort(lcm.villains, new Villain());
        for (Villain villain : lcm.villains) {
            for (VillainCard vc : villain.cards) {
                if (vc.cardType == null || !vc.cardType.equals((Object)VillainCardType.BYSTANDER)) continue;
                this.bystanderListModel.addElement(vc);
            }
        }
        this.bystanderList = new JList(this.bystanderListModel);
        this.bystanderList.setCellRenderer(new BystanderListRenderer());
        this.bystanderList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    VillainMakerFrame villainMakerFrame = new VillainMakerFrame((VillainCard)list.getSelectedValue());
                }
            }
        });
        this.bystanderScroll.setViewportView(this.bystanderList);
        this.add(this.bystanderScroll);
        this.tabs.add("Bystanders", this.bystanderScroll);
        this.woundListModel = new DefaultListModel();
        Collections.sort(lcm.villains, new Villain());
        for (Villain villain : lcm.villains) {
            for (VillainCard vc : villain.cards) {
                if (vc.cardType == null || !vc.cardType.equals((Object)VillainCardType.WOUND)) continue;
                this.woundListModel.addElement(vc);
            }
        }
        this.woundList = new JList(this.woundListModel);
        this.woundList.setCellRenderer(new WoundListRenderer());
        this.woundList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    VillainMakerFrame villainMakerFrame = new VillainMakerFrame((VillainCard)list.getSelectedValue());
                }
            }
        });
        this.woundScroll.setViewportView(this.woundList);
        this.add(this.woundScroll);
        this.tabs.add("Wounds", this.woundScroll);
        this.bindingsListModel = new DefaultListModel();
        Collections.sort(lcm.villains, new Villain());
        for (Villain villain : lcm.villains) {
            for (VillainCard vc : villain.cards) {
                if (vc.cardType == null || !vc.cardType.equals((Object)VillainCardType.BINDINGS)) continue;
                this.bindingsListModel.addElement(vc);
            }
        }
        this.bindingsList = new JList(this.bindingsListModel);
        this.bindingsList.setCellRenderer(new BindingsListRenderer());
        this.bindingsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    VillainMakerFrame villainMakerFrame = new VillainMakerFrame((VillainCard)list.getSelectedValue());
                }
            }
        });
        this.bindingsScroll.setViewportView(this.bindingsList);
        this.add(this.bindingsScroll);
        this.tabs.add("Bindings", this.bindingsScroll);
        this.schemeListModel = new DefaultListModel();
        Collections.sort(lcm.schemes, new SchemeCard());
        for (SchemeCard schemeCard : lcm.schemes) {
            this.schemeListModel.addElement(schemeCard);
        }
        this.schemeList = new JList(this.schemeListModel);
        this.schemeList.setCellRenderer(new SchemeListRenderer());
        this.schemeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    SchemeMakerFrame schemeMakerFrame = new SchemeMakerFrame((SchemeCard)list.getSelectedValue());
                }
            }
        });
        this.schemeScroll.setViewportView(this.schemeList);
        this.add(this.schemeScroll);
        this.tabs.add("Schemes", this.schemeScroll);
        for (CustomTemplate customTemplate : lcm.allTemplates) {
            Object list = this.customTemplateListSet.get(customTemplate.tab);
            if (list == null) {
                list = new CustomTemplateList(customTemplate, lcm.customCards, lcm.customStructures);
                this.customTemplateListSet.put(customTemplate.tab, (CustomTemplateList)list);
                continue;
            }
            ((CustomTemplateList)list).addTemplate(customTemplate, lcm.customCards);
        }
        Set<Map.Entry<String, CustomTemplateList>> set = this.customTemplateListSet.entrySet();
        for (Map.Entry entry : set) {
            this.tabs.add((String)entry.getKey(), (Component)entry.getValue());
        }
        this.teamListModel = new DefaultListModel();
        List<Icon> list = Icon.values();
        Collections.sort(list, new Icon());
        for (Icon v : list) {
            if (!v.getIconType().equals((Object)Icon.ICON_TYPE.TEAM)) continue;
            this.teamListModel.addElement(v);
        }
        this.teamList = new JList(this.teamListModel);
        this.teamList.setCellRenderer(new TeamListRenderer());
        this.teamList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int n = list.locationToIndex(evt.getPoint());
                }
            }
        });
        this.teamScroll.setViewportView(this.teamList);
        this.add(this.teamScroll);
        this.tabs.add("Teams", this.teamScroll);
        this.schemeTypeListModel = new DefaultListModel();
        List<SchemeCardType> schemeTypes = SchemeCardType.values();
        Collections.sort(schemeTypes, new SchemeCardType());
        for (SchemeCardType v : schemeTypes) {
            this.schemeTypeListModel.addElement(v);
        }
        this.schemeTypeList = new JList(this.schemeTypeListModel);
        this.schemeTypeList.setCellRenderer(new SchemeTypeListRenderer());
        this.schemeTypeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int n = list.locationToIndex(evt.getPoint());
                }
            }
        });
        this.schemeTypeScroll.setViewportView(this.schemeTypeList);
        this.add(this.schemeTypeScroll);
        this.tabs.add("Scheme Types", this.schemeTypeScroll);
        if (this.applicationProps.get("lastTab") != null) {
            String title = (String)this.applicationProps.get("lastTab");
            int i = 0;
            while (i < this.tabs.getTabCount()) {
                if (this.tabs.getTitleAt(i).equals(title)) {
                    this.tabs.setSelectedIndex(i);
                }
                ++i;
            }
        }
        this.add(this.tabs);
        this.toolbar = new CardMakerToolbar(this);
        this.setJMenuBar(this.toolbar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int outcome;
                if (LegendaryCardMakerFrame.lcmf.lcm.doChangesExist() && (outcome = JOptionPane.showOptionDialog(lcmf, String.valueOf(LegendaryCardMakerFrame.this.labels.getString("SaveChanges")) + "?", LegendaryCardMakerFrame.this.labels.getString("SaveChanges"), 0, 3, null, null, null)) == 0) {
                    if (LegendaryCardMakerFrame.lcmf.lcm.currentFile != null && new File(LegendaryCardMakerFrame.lcmf.lcm.currentFile).exists()) {
                        try {
                            LegendaryCardMakerFrame.lcmf.lcm.saveExpansion();
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(lcmf, "Error! " + ex.getMessage());
                        }
                    } else {
                        JFileChooser chooser = new JFileChooser();
                        int outcome2 = chooser.showSaveDialog(e.getWindow());
                        if (outcome2 == 0) {
                            LegendaryCardMakerFrame.lcmf.lcm.currentFile = chooser.getSelectedFile().getAbsolutePath();
                            try {
                                LegendaryCardMakerFrame.lcmf.lcm.saveExpansion();
                                LegendaryCardMakerFrame.lcmf.applicationProps.put("lastSaveDirectory", chooser.getSelectedFile().getParent());
                                LegendaryCardMakerFrame.lcmf.lcm.lastSaved = chooser.getSelectedFile().getParent();
                                lcmf.saveProperties();
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(lcmf, "Error! " + ex.getMessage());
                            }
                        }
                    }
                }
                e.getWindow().dispose();
                System.exit(0);
            }
        });
        this.setSize(500, 500);
        this.setVisible(true);
    }

    public BufferedImage getCardIcon(Icon icon, int maxWidth, int maxHeight) {
        if (icon == null || icon.getImagePath() == null) {
            int type = 2;
            BufferedImage image = new BufferedImage(maxWidth, maxHeight, type);
            return image;
        }
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = 1.0;
        double rX = (double)maxWidth / (double)ii.getIconWidth();
        double rY = (double)maxHeight / (double)ii.getIconHeight();
        r = rY < rX ? rY : rX;
        return this.resizeImage(ii, r);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public void loadProperties() {
        try {
            FileInputStream in = new FileInputStream("appProperties");
            this.applicationProps.load(in);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream("appProperties");
            this.applicationProps.store(out, "---No Comment---");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createNewExpansion() {
        this.lcm.expansionName = "";
        this.lcm.rules = "";
        this.lcm.keywords = "";
        this.lcm.heroes = new ArrayList<Hero>();
        this.lcm.villains = new ArrayList<Villain>();
        this.lcm.schemes = new ArrayList<SchemeCard>();
        this.lcm.customCards = new ArrayList<CustomCard>();
        this.lcm.dividerHorizontal = true;
        this.lcm.dbImageOffsetX = 0;
        this.lcm.dbImageOffsetY = 0;
        this.lcm.dbImagePath = null;
        this.lcm.dbImageZoom = 1.0;
        this.lcm.dividerCardStyle = "PowerIcons";
        this.lcm.dividerBodyStyle = "Images";
        this.lcm.inputFile = null;
        this.lcm.textOutputFile = null;
        this.lcm.textErrorFile = "error.txt";
        this.lcm.exportFolder = null;
        this.lcm.textDividerFile = null;
        this.lcm.currentFile = null;
        this.heroListModel.clear();
        this.villainListModel.clear();
        this.schemeListModel.clear();
        this.bystanderListModel.clear();
        this.woundListModel.clear();
        Set<Map.Entry<String, CustomTemplateList>> entrySet = LegendaryCardMakerFrame.lcmf.customTemplateListSet.entrySet();
        for (Map.Entry<String, CustomTemplateList> entry : entrySet) {
            entry.getValue().cardListModel.clear();
        }
        this.setTitle("Legendedit - [Untitled]");
    }

    public class BindingsListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            VillainCard villain = (VillainCard)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setHorizontalTextPosition(4);
            String s = villain.name;
            if (villain.changed) {
                s = String.valueOf(s) + " *";
            }
            label.setText(s);
            return label;
        }
    }

    public class BystanderListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            VillainCard villain = (VillainCard)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setHorizontalTextPosition(4);
            String s = villain.name;
            if (villain.changed) {
                s = String.valueOf(s) + " *";
            }
            label.setText(s);
            return label;
        }
    }

    public class HeroListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Hero hero = (Hero)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (hero.imageSummary != null) {
                label.setIcon(hero.imageSummary);
            } else {
                hero.imageSummary = new ImageIcon(this.getImageSummary(hero));
                label.setIcon(hero.imageSummary);
            }
            label.setHorizontalTextPosition(4);
            String s = hero.name;
            boolean changed = false;
            for (HeroCard hc : hero.cards) {
                if (!hc.changed) continue;
                changed = true;
            }
            if (hero.changed || changed) {
                s = String.valueOf(s) + " *";
            }
            label.setText(s);
            return label;
        }

        private BufferedImage getImageSummary(Hero h) {
            int maxWidth = 24;
            int maxHeight = 24;
            BufferedImage bi = new BufferedImage(maxWidth * (h.cards.size() + 1 + 1), maxHeight, 2);
            Graphics g2 = bi.getGraphics();
            Icon teamIcon = Icon.valueOf("");
            HashMap<Icon, Integer> teamMap = new HashMap<Icon, Integer>();
            for (HeroCard hc : h.cards) {
                if (teamMap.containsKey(hc.cardTeam)) {
                    Integer i = (Integer)teamMap.get(hc.cardTeam);
                    i = new Integer(i + 1);
                    teamMap.put(hc.cardTeam, i);
                } else {
                    teamMap.put(hc.cardTeam, new Integer(1));
                }
                int count = 0;
                for (Map.Entry en : teamMap.entrySet()) {
                    if ((Integer)en.getValue() <= count) continue;
                    count = (Integer)en.getValue();
                    teamIcon = (Icon)en.getKey();
                }
            }
            int offset = 0;
            BufferedImage icon = LegendaryCardMakerFrame.this.getCardIcon(teamIcon, maxWidth, maxHeight);
            g2.drawImage(icon, offset + (maxWidth / 2 - icon.getWidth() / 2), maxHeight / 2 - icon.getHeight() / 2, null);
            offset += maxWidth;
            for (HeroCard hc : h.cards) {
                icon = LegendaryCardMakerFrame.this.getCardIcon(hc.cardPower, maxWidth, maxHeight);
                g2.drawImage(icon, offset + (maxWidth / 2 - icon.getWidth() / 2), maxHeight / 2 - icon.getHeight() / 2, null);
                offset += maxWidth;
            }
            g2.dispose();
            return bi;
        }
    }

    public class SchemeListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SchemeCard villain = (SchemeCard)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setHorizontalTextPosition(4);
            String s = villain.name;
            if (villain.cardType != null) {
                s = String.valueOf(s) + " (" + villain.cardType.toString() + ")";
            }
            if (villain.changed) {
                s = String.valueOf(s) + " *";
            }
            label.setText(s);
            return label;
        }
    }

    public class SchemeTypeListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SchemeCardType type = (SchemeCardType)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setHorizontalTextPosition(4);
            String s = String.valueOf(type.getDisplayString()) + " (" + (type.doesAllowHeadings() ? "Custom Headers" : "Set Header") + ")";
            label.setText(s);
            label.setIcon(new ImageIcon(this.getColorSummary(type)));
            return label;
        }

        private BufferedImage getColorSummary(SchemeCardType type) {
            int maxWidth = 20;
            int maxHeight = 20;
            BufferedImage bi = new BufferedImage(maxWidth, maxHeight, 2);
            Graphics g2 = bi.getGraphics();
            g2.setColor(type.getBgColor());
            g2.fillRect(0, 0, maxWidth, maxHeight);
            g2.dispose();
            return bi;
        }
    }

    public class TeamListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon villain = (Icon)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setIcon(new ImageIcon(this.getImageSummary(villain)));
            label.setHorizontalTextPosition(4);
            String s = villain.getEnumName();
            label.setText(s);
            return label;
        }

        private BufferedImage getImageSummary(Icon v) {
            int maxWidth = 24;
            int maxHeight = 24;
            BufferedImage bi = new BufferedImage(maxWidth * 2, maxHeight, 2);
            Graphics g2 = bi.getGraphics();
            int offset = 0;
            BufferedImage icon = LegendaryCardMakerFrame.this.getCardIcon(v, maxWidth, maxHeight);
            g2.drawImage(icon, offset + (maxWidth / 2 - icon.getWidth() / 2), maxHeight / 2 - icon.getHeight() / 2, null);
            g2.dispose();
            return bi;
        }
    }

    public class VillainListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Villain villain = (Villain)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setIcon(new ImageIcon(this.getImageSummary(villain)));
            label.setHorizontalTextPosition(4);
            String s = villain.name;
            boolean changed = false;
            for (VillainCard vc : villain.cards) {
                if (!vc.changed) continue;
                changed = true;
            }
            if (villain.changed || changed) {
                s = String.valueOf(s) + " *";
            }
            label.setText(s);
            return label;
        }

        private BufferedImage getImageSummary(Villain v) {
            int maxWidth = 24;
            int maxHeight = 24;
            BufferedImage bi = new BufferedImage(maxWidth * 2, maxHeight, 2);
            Graphics g2 = bi.getGraphics();
            Icon teamIcon = Icon.valueOf("");
            HashMap<Icon, Integer> teamMap = new HashMap<Icon, Integer>();
            for (VillainCard hc : v.cards) {
                if (teamMap.containsKey(hc.cardTeam)) {
                    Integer i = (Integer)teamMap.get(hc.cardTeam);
                    i = new Integer(i + 1);
                    teamMap.put(hc.cardTeam, i);
                } else {
                    teamMap.put(hc.cardTeam, new Integer(1));
                }
                int count = 0;
                for (Map.Entry en : teamMap.entrySet()) {
                    if ((Integer)en.getValue() <= count) continue;
                    count = (Integer)en.getValue();
                    teamIcon = (Icon)en.getKey();
                }
            }
            int offset = 0;
            BufferedImage icon = LegendaryCardMakerFrame.this.getCardIcon(teamIcon, maxWidth, maxHeight);
            g2.drawImage(icon, offset + (maxWidth / 2 - icon.getWidth() / 2), maxHeight / 2 - icon.getHeight() / 2, null);
            g2.dispose();
            return bi;
        }
    }

    public class WoundListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            VillainCard villain = (VillainCard)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setHorizontalTextPosition(4);
            String s = villain.name;
            if (villain.changed) {
                s = String.valueOf(s) + " *";
            }
            label.setText(s);
            return label;
        }
    }
}

